import { ExtensionModule } from "@activeviam/atoti-ui-sdk";

import { pluginWidgetExample } from "./pluginWidgetExample.js";
import { withNotification } from "./withNotification.js";

const extension: ExtensionModule = {
  async activate(configuration) {
    configuration.higherOrderComponents.push(withNotification);

    configuration.initialDashboardPageState!.content[0] =
      pluginWidgetExample.initialState;

    configuration.pluginRegistry.widget![pluginWidgetExample.key] =
      pluginWidgetExample;
  },
};

// Atoti UI expects a default export.
// eslint-disable-next-line import/no-default-export
export default extension;
