import { App } from "antd";
import { type ComponentType, useEffect } from "react";

export const withNotification = <P extends JSX.IntrinsicAttributes>(
  Component: ComponentType<P>,
): ComponentType<P> => {
  const Wrapped = (props: P) => {
    const { notification } = App.useApp();

    useEffect(() => {
      notification.success({
        message: "Extension activated!",
        placement: "topLeft",
      });
    }, [notification]);

    return <Component {...props} />;
  };

  const name = Component.displayName ?? Component.name ?? "Unknown";
  Wrapped.displayName = `withNotification(${name})`;
  return Wrapped;
};
