import { Empty } from "antd";
import { FunctionComponent } from "react";
import { useIntl } from "react-intl";

import {
  AWidgetState,
  WidgetPlugin,
  WidgetPluginProps,
} from "@activeviam/atoti-ui-sdk";

type SelectionType = unknown;
type WidgetState = AWidgetState;

const key = "example";

const Example: FunctionComponent<
  WidgetPluginProps<WidgetState, SelectionType>
> = () => {
  const { formatMessage } = useIntl();

  return (
    <Empty
      description={formatMessage({ id: `aui.plugins.widget.${key}.text` })}
    />
  );
};

export const pluginWidgetExample: WidgetPlugin<WidgetState, SelectionType> = {
  Component: Example,
  initialState: { widgetKey: key },
  key,
  translations: {
    "en-US": {
      defaultName: "New example",
      text: "Just an example.",
    },
  },
};
