/** @jsx jsx */
import { jsx } from "@emotion/core";
import Empty from "antd/lib/empty";
import { ComponentType } from "react";
import { useIntl } from "react-intl";

import {
  AWidgetState,
  WidgetPlugin,
  WidgetPluginProps,
} from "@activeviam/activeui-sdk";

type SelectionType = unknown;
type WidgetState = AWidgetState;

const key = "example";

const Example: ComponentType<
  WidgetPluginProps<WidgetState, SelectionType>
> = () => {
  const { formatMessage } = useIntl();

  return (
    <Empty
      description={formatMessage({ id: `aui.plugins.widget.${key}.text` })}
    />
  );
};

export const pluginWidgetExample: WidgetPlugin<WidgetState, SelectionType> = {
  Component: Example,
  initialState: { widgetKey: key },
  key,
  translations: {
    "en-US": {
      defaultName: "New example",
      text: "Just an example.",
    },
  },
};
