/** @jsx jsx */

import { jsx } from "@emotion/core";
import ConfigProvider from "antd/lib/config-provider";
import notification from "antd/lib/notification";
import { ComponentType, useContext, useEffect } from "react";

const { ConfigContext: AntdContext } = ConfigProvider;

export const withNotification = <P,>(
  Component: ComponentType<P>,
): ComponentType<P> => {
  const Wrapped = (props: P) => {
    const { getPopupContainer } = useContext(AntdContext);

    useEffect(() => {
      notification.success({
        // @ts-expect-error: getPopupContainer() expects to be passed an HTML element but it works fine without one.
        getContainer: getPopupContainer,
        message: "Extension activated!",
        placement: "topLeft",
      });
    }, [getPopupContainer]);

    return <Component {...props} />;
  };

  const name = Component.displayName ?? Component.name ?? "Unknown";
  Wrapped.displayName = `withNotification(${name})`;
  return Wrapped;
};
