import { ExtensionModule } from "@activeviam/activeui-sdk";
import { pluginWidgetExample } from "./pluginWidgetExample";
import { withNotification } from "./withNotification";

const extension: ExtensionModule = {
  async activate(configuration) {
    configuration.higherOrderComponents!.push(withNotification);

    configuration.initialDashboardPageState!.content[0] =
      pluginWidgetExample.initialState;

    configuration.pluginRegistry.widget![
      pluginWidgetExample.key
    ] = pluginWidgetExample;
  },
};

// ActiveUI expects a default export.
// eslint-disable-next-line import/no-default-export
export default extension;
